package com.xforceplus.jcliutao.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcliutao.entity.Teacher;
import com.xforceplus.jcliutao.service.ITeacherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-15
 */
@RestController
public class TeacherController {

  @Autowired
  private ITeacherService teacherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param teacher ${table.comment}
   * @return
   */
  @GetMapping("/teachers" )
  public XfR getTeachers(XfPage page, Teacher teacher) {
    return XfR.ok(teacherServiceImpl.page(page, Wrappers.query(teacher)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/teachers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(teacherServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param teacher ${table.comment}
   * @return XfR
   */
  @PostMapping("/teachers")
  public XfR save(@RequestBody Teacher teacher) {
     return XfR.ok(teacherServiceImpl.save(teacher));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param teacher ${table.comment}
   * @return XfR
   */
  @PutMapping("/teachers/{id}")
  public XfR putUpdate(@RequestBody Teacher teacher,@PathVariable Long id) {
      teacher.setId(id);
      return XfR.ok(teacherServiceImpl.updateById(teacher));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param teacher ${table.comment}
   * @return XfR
   */
  @PatchMapping("/teachers/{id}")
  public XfR patchUpdate(@RequestBody Teacher teacher,@PathVariable Long id) {
      Teacher upteacher = teacherServiceImpl.getById(id);
      if(upteacher != null){
        upteacher = ObjectCopyUtils.copyProperties(teacher,upteacher,true);
      }
      return XfR.ok(teacherServiceImpl.updateById(upteacher));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/teachers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(teacherServiceImpl.removeById(id));
  }

  @PostMapping("/teachers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "teacher");
     params.put("request", condition);

     return XfR.ok(teacherServiceImpl.querys(params));
  }

}
