package com.xforceplus.jclusilong.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-06-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclusilong.entity.Boss;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-lusilong")
public interface BossFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/boss/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param boss ${table.comment}
   * @return R
   */
  @PostMapping("/boss/add")
  public R save(@RequestBody Boss boss);

  /**
   * 修改${table.comment}
   * @param boss ${table.comment}
   * @return R
   */
  @PostMapping("/boss/update")
  public R updateById(@RequestBody Boss boss);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/boss/del/{id}" )
  public R removeById(@PathVariable Long id);

}