package com.xforceplus.jclusilong.controller;


/**
 * 导入发票明细feign客户端
 *
 * @author ultraman
 * @date 2023-06-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclusilong.entity.ImportInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-lusilong")
public interface ImportInvoiceFeignApi {

  /**
   * 通过id查询导入发票明细
   * @param  id
   * @return R
   */
  @GetMapping("/importInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增导入发票明细
   * @param importInvoice 导入发票明细
   * @return R
   */
  @PostMapping("/importInvoice/add")
  public R save(@RequestBody ImportInvoice importInvoice);

  /**
   * 修改导入发票明细
   * @param importInvoice 导入发票明细
   * @return R
   */
  @PostMapping("/importInvoice/update")
  public R updateById(@RequestBody ImportInvoice importInvoice);

  /**
   * 通过id删除导入发票明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/importInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}