package com.xforceplus.jclusilong.controller;


/**
 * 库存记录feign客户端
 *
 * @author ultraman
 * @date 2023-06-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclusilong.entity.InventoryDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-lusilong")
public interface InventoryDetailFeignApi {

  /**
   * 通过id查询库存记录
   * @param  id
   * @return R
   */
  @GetMapping("/inventoryDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增库存记录
   * @param inventoryDetail 库存记录
   * @return R
   */
  @PostMapping("/inventoryDetail/add")
  public R save(@RequestBody InventoryDetail inventoryDetail);

  /**
   * 修改库存记录
   * @param inventoryDetail 库存记录
   * @return R
   */
  @PostMapping("/inventoryDetail/update")
  public R updateById(@RequestBody InventoryDetail inventoryDetail);

  /**
   * 通过id删除库存记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/inventoryDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}