package com.xforceplus.jclusilong.controller;


/**
 * 商品信息feign客户端
 *
 * @author ultraman
 * @date 2023-06-16
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclusilong.entity.GoodsInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-lusilong")
public interface GoodsInfoFeignApi {

  /**
   * 通过id查询商品信息
   * @param  id
   * @return R
   */
  @GetMapping("/goodsInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增商品信息
   * @param goodsInfo 商品信息
   * @return R
   */
  @PostMapping("/goodsInfo/add")
  public R save(@RequestBody GoodsInfo goodsInfo);

  /**
   * 修改商品信息
   * @param goodsInfo 商品信息
   * @return R
   */
  @PostMapping("/goodsInfo/update")
  public R updateById(@RequestBody GoodsInfo goodsInfo);

  /**
   * 通过id删除商品信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/goodsInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}