package com.xforceplus.jclusilong.controller;


/**
 * OQSSDK运维工具操作记录feign客户端
 *
 * @author ultraman
 * @date 2023-06-16
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclusilong.entity.OqsengineSdkOmAuditLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-lusilong")
public interface OqsengineSdkOmAuditLogFeignApi {

  /**
   * 通过id查询OQSSDK运维工具操作记录
   * @param  id
   * @return R
   */
  @GetMapping("/oqsengineSdkOmAuditLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增OQSSDK运维工具操作记录
   * @param oqsengineSdkOmAuditLog OQSSDK运维工具操作记录
   * @return R
   */
  @PostMapping("/oqsengineSdkOmAuditLog/add")
  public R save(@RequestBody OqsengineSdkOmAuditLog oqsengineSdkOmAuditLog);

  /**
   * 修改OQSSDK运维工具操作记录
   * @param oqsengineSdkOmAuditLog OQSSDK运维工具操作记录
   * @return R
   */
  @PostMapping("/oqsengineSdkOmAuditLog/update")
  public R updateById(@RequestBody OqsengineSdkOmAuditLog oqsengineSdkOmAuditLog);

  /**
   * 通过id删除OQSSDK运维工具操作记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/oqsengineSdkOmAuditLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}