package com.xforceplus.jclxhbz.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-06-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclxhbz.entity.CompanyInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-lxhbz")
public interface CompanyInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/companyInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param companyInfo ${table.comment}
   * @return R
   */
  @PostMapping("/companyInfo/add")
  public R save(@RequestBody CompanyInfo companyInfo);

  /**
   * 修改${table.comment}
   * @param companyInfo ${table.comment}
   * @return R
   */
  @PostMapping("/companyInfo/update")
  public R updateById(@RequestBody CompanyInfo companyInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/companyInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}