package com.xforceplus.jclxhbz.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclxhbz.entity.ProductInfo;
import com.xforceplus.jclxhbz.service.IProductInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-18
 */
@RestController
public class ProductInfoController {

  @Autowired
  private IProductInfoService productInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productInfo ${table.comment}
   * @return
   */
  @GetMapping("/productinfos" )
  public XfR getProductInfos(XfPage page, ProductInfo productInfo) {
    return XfR.ok(productInfoServiceImpl.page(page, Wrappers.query(productInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/productinfos")
  public XfR save(@RequestBody ProductInfo productInfo) {
     return XfR.ok(productInfoServiceImpl.save(productInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/productinfos/{id}")
  public XfR putUpdate(@RequestBody ProductInfo productInfo,@PathVariable Long id) {
      productInfo.setId(id);
      return XfR.ok(productInfoServiceImpl.updateById(productInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productinfos/{id}")
  public XfR patchUpdate(@RequestBody ProductInfo productInfo,@PathVariable Long id) {
      ProductInfo upproductInfo = productInfoServiceImpl.getById(id);
      if(upproductInfo != null){
        upproductInfo = ObjectCopyUtils.copyProperties(productInfo,upproductInfo,true);
      }
      return XfR.ok(productInfoServiceImpl.updateById(upproductInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productInfoServiceImpl.removeById(id));
  }

  @PostMapping("/productinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_info");
     params.put("request", condition);

     return XfR.ok(productInfoServiceImpl.querys(params));
  }

}
