package com.xforceplus.jclxhbz.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclxhbz.entity.RebateBizOrderDetail;
import com.xforceplus.jclxhbz.service.IRebateBizOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-18
 */
@RestController
public class RebateBizOrderDetailController {

  @Autowired
  private IRebateBizOrderDetailService rebateBizOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rebateBizOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/rebatebizorderdetails" )
  public XfR getRebateBizOrderDetails(XfPage page, RebateBizOrderDetail rebateBizOrderDetail) {
    return XfR.ok(rebateBizOrderDetailServiceImpl.page(page, Wrappers.query(rebateBizOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rebatebizorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(rebateBizOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param rebateBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/rebatebizorderdetails")
  public XfR save(@RequestBody RebateBizOrderDetail rebateBizOrderDetail) {
     return XfR.ok(rebateBizOrderDetailServiceImpl.save(rebateBizOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param rebateBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/rebatebizorderdetails/{id}")
  public XfR putUpdate(@RequestBody RebateBizOrderDetail rebateBizOrderDetail,@PathVariable Long id) {
      rebateBizOrderDetail.setId(id);
      return XfR.ok(rebateBizOrderDetailServiceImpl.updateById(rebateBizOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param rebateBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rebatebizorderdetails/{id}")
  public XfR patchUpdate(@RequestBody RebateBizOrderDetail rebateBizOrderDetail,@PathVariable Long id) {
      RebateBizOrderDetail uprebateBizOrderDetail = rebateBizOrderDetailServiceImpl.getById(id);
      if(uprebateBizOrderDetail != null){
        uprebateBizOrderDetail = ObjectCopyUtils.copyProperties(rebateBizOrderDetail,uprebateBizOrderDetail,true);
      }
      return XfR.ok(rebateBizOrderDetailServiceImpl.updateById(uprebateBizOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rebatebizorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(rebateBizOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/rebatebizorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rebate_biz_order_detail");
     params.put("request", condition);

     return XfR.ok(rebateBizOrderDetailServiceImpl.querys(params));
  }

}
