package com.xforceplus.jclxhbz.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclxhbz.entity.RebateBizOrderMain;
import com.xforceplus.jclxhbz.service.IRebateBizOrderMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-18
 */
@RestController
public class RebateBizOrderMainController {

  @Autowired
  private IRebateBizOrderMainService rebateBizOrderMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rebateBizOrderMain ${table.comment}
   * @return
   */
  @GetMapping("/rebatebizordermains" )
  public XfR getRebateBizOrderMains(XfPage page, RebateBizOrderMain rebateBizOrderMain) {
    return XfR.ok(rebateBizOrderMainServiceImpl.page(page, Wrappers.query(rebateBizOrderMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rebatebizordermains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(rebateBizOrderMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param rebateBizOrderMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/rebatebizordermains")
  public XfR save(@RequestBody RebateBizOrderMain rebateBizOrderMain) {
     return XfR.ok(rebateBizOrderMainServiceImpl.save(rebateBizOrderMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param rebateBizOrderMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/rebatebizordermains/{id}")
  public XfR putUpdate(@RequestBody RebateBizOrderMain rebateBizOrderMain,@PathVariable Long id) {
      rebateBizOrderMain.setId(id);
      return XfR.ok(rebateBizOrderMainServiceImpl.updateById(rebateBizOrderMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param rebateBizOrderMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rebatebizordermains/{id}")
  public XfR patchUpdate(@RequestBody RebateBizOrderMain rebateBizOrderMain,@PathVariable Long id) {
      RebateBizOrderMain uprebateBizOrderMain = rebateBizOrderMainServiceImpl.getById(id);
      if(uprebateBizOrderMain != null){
        uprebateBizOrderMain = ObjectCopyUtils.copyProperties(rebateBizOrderMain,uprebateBizOrderMain,true);
      }
      return XfR.ok(rebateBizOrderMainServiceImpl.updateById(uprebateBizOrderMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rebatebizordermains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(rebateBizOrderMainServiceImpl.removeById(id));
  }

  @PostMapping("/rebatebizordermains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rebate_biz_order_main");
     params.put("request", condition);

     return XfR.ok(rebateBizOrderMainServiceImpl.querys(params));
  }

}
