package com.xforceplus.jclxhbz.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jclxhbz.entity.BizOrderMain;
import com.xforceplus.jclxhbz.service.IBizOrderMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-27
 */
@RestController
public class BizOrderMainController {

  @Autowired
  private IBizOrderMainService bizOrderMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderMain ${table.comment}
   * @return
   */
  @GetMapping("/bizordermains" )
  public XfR getBizOrderMains(XfPage page, BizOrderMain bizOrderMain) {
    return XfR.ok(bizOrderMainServiceImpl.page(page, Wrappers.query(bizOrderMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizordermains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizordermains")
  public XfR save(@RequestBody BizOrderMain bizOrderMain) {
     return XfR.ok(bizOrderMainServiceImpl.save(bizOrderMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizordermains/{id}")
  public XfR putUpdate(@RequestBody BizOrderMain bizOrderMain,@PathVariable Long id) {
      bizOrderMain.setId(id);
      return XfR.ok(bizOrderMainServiceImpl.updateById(bizOrderMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizordermains/{id}")
  public XfR patchUpdate(@RequestBody BizOrderMain bizOrderMain,@PathVariable Long id) {
      BizOrderMain upbizOrderMain = bizOrderMainServiceImpl.getById(id);
      if(upbizOrderMain != null){
        upbizOrderMain = ObjectCopyUtils.copyProperties(bizOrderMain,upbizOrderMain,true);
      }
      return XfR.ok(bizOrderMainServiceImpl.updateById(upbizOrderMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizordermains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderMainServiceImpl.removeById(id));
  }

  @PostMapping("/bizordermains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_main");
     params.put("request", condition);

     return XfR.ok(bizOrderMainServiceImpl.querys(params));
  }

}
