package com.xforceplus.jcmars.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmars.entity.BillingRecord;
import com.xforceplus.jcmars.service.IBillingRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 单据明细导入履历前端控制器
 *
 * @author ultraman
 * @date 2021-12-31
 */
@RestController
public class BillingRecordController {

  @Autowired
  private IBillingRecordService billingRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingRecord 单据明细导入履历
   * @return
   */
  @GetMapping("/billingrecords" )
  public XfR getBillingRecords(XfPage page, BillingRecord billingRecord) {
    return XfR.ok(billingRecordServiceImpl.page(page, Wrappers.query(billingRecord)));
  }

  /**
   * 通过id查询单据明细导入履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingRecordServiceImpl.getById(id));
  }

  /**
   * 新增单据明细导入履历
   * @param billingRecord 单据明细导入履历
   * @return XfR
   */
  @PostMapping("/billingrecords")
  public XfR save(@RequestBody BillingRecord billingRecord) {
     return XfR.ok(billingRecordServiceImpl.save(billingRecord));
  }

  /**
   * 修改-传入修改后的全部数据单据明细导入履历
   * @param billingRecord 单据明细导入履历
   * @return XfR
   */
  @PutMapping("/billingrecords/{id}")
  public XfR putUpdate(@RequestBody BillingRecord billingRecord,@PathVariable Long id) {
      billingRecord.setId(id);
      return XfR.ok(billingRecordServiceImpl.updateById(billingRecord));
  }

  /**
   * 修改-传入修改的数据单据明细导入履历
   * @param billingRecord 单据明细导入履历
   * @return XfR
   */
  @PatchMapping("/billingrecords/{id}")
  public XfR patchUpdate(@RequestBody BillingRecord billingRecord,@PathVariable Long id) {
      BillingRecord upbillingRecord = billingRecordServiceImpl.getById(id);
      if(upbillingRecord != null){
        upbillingRecord = ObjectCopyUtils.copyProperties(billingRecord,upbillingRecord,true);
      }
      return XfR.ok(billingRecordServiceImpl.updateById(upbillingRecord));
  }

  /**
   * 通过id删除单据明细导入履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingRecordServiceImpl.removeById(id));
  }

  @PostMapping("/billingrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_record");
     params.put("request", condition);

     return XfR.ok(billingRecordServiceImpl.querys(params));
  }

}
