package com.xforceplus.jcmeiyijia.controller;


/**
 * 发票附件影像feign客户端
 *
 * @author ultraman
 * @date 2021-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.AttachImages;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface AttachImagesFeignApi {

  /**
   * 通过id查询发票附件影像
   * @param  id
   * @return R
   */
  @GetMapping("/attachImages/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票附件影像
   * @param attachImages 发票附件影像
   * @return R
   */
  @PostMapping("/attachImages/add")
  public R save(@RequestBody AttachImages attachImages);

  /**
   * 修改发票附件影像
   * @param attachImages 发票附件影像
   * @return R
   */
  @PostMapping("/attachImages/update")
  public R updateById(@RequestBody AttachImages attachImages);

  /**
   * 通过id删除发票附件影像
   * @param  id
   * @return R
   */
  @DeleteMapping("/attachImages/del/{id}" )
  public R removeById(@PathVariable Long id);

}