package com.xforceplus.jcmeiyijia.controller;


/**
 * 品类（大类）管理feign客户端
 *
 * @author ultraman
 * @date 2021-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.CategoryMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface CategoryMainFeignApi {

  /**
   * 通过id查询品类（大类）管理
   * @param  id
   * @return R
   */
  @GetMapping("/categoryMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增品类（大类）管理
   * @param categoryMain 品类（大类）管理
   * @return R
   */
  @PostMapping("/categoryMain/add")
  public R save(@RequestBody CategoryMain categoryMain);

  /**
   * 修改品类（大类）管理
   * @param categoryMain 品类（大类）管理
   * @return R
   */
  @PostMapping("/categoryMain/update")
  public R updateById(@RequestBody CategoryMain categoryMain);

  /**
   * 通过id删除品类（大类）管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/categoryMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}