package com.xforceplus.jcmeiyijia.controller;


/**
 * 商品审批管理feign客户端
 *
 * @author ultraman
 * @date 2021-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.GoodsExamine;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface GoodsExamineFeignApi {

  /**
   * 通过id查询商品审批管理
   * @param  id
   * @return R
   */
  @GetMapping("/goodsExamine/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增商品审批管理
   * @param goodsExamine 商品审批管理
   * @return R
   */
  @PostMapping("/goodsExamine/add")
  public R save(@RequestBody GoodsExamine goodsExamine);

  /**
   * 修改商品审批管理
   * @param goodsExamine 商品审批管理
   * @return R
   */
  @PostMapping("/goodsExamine/update")
  public R updateById(@RequestBody GoodsExamine goodsExamine);

  /**
   * 通过id删除商品审批管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/goodsExamine/del/{id}" )
  public R removeById(@PathVariable Long id);

}