package com.xforceplus.jcmeiyijia.controller;


/**
 * 发票勾选管理feign客户端
 *
 * @author ultraman
 * @date 2021-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.InvoiceAuth;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface InvoiceAuthFeignApi {

  /**
   * 通过id查询发票勾选管理
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceAuth/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票勾选管理
   * @param invoiceAuth 发票勾选管理
   * @return R
   */
  @PostMapping("/invoiceAuth/add")
  public R save(@RequestBody InvoiceAuth invoiceAuth);

  /**
   * 修改发票勾选管理
   * @param invoiceAuth 发票勾选管理
   * @return R
   */
  @PostMapping("/invoiceAuth/update")
  public R updateById(@RequestBody InvoiceAuth invoiceAuth);

  /**
   * 通过id删除发票勾选管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceAuth/del/{id}" )
  public R removeById(@PathVariable Long id);

}