package com.xforceplus.jcmeiyijia.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据流向
 * </p>
 *
 * @author ultraman
 * @since 2021-09-16
 */
public enum DataFlow {

    _1("1", "客户=>属地"),
    _2("2", "属地=>平台"),
    _3("3", "平台=>属地"),
    _4("4", "属地=>客户");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DataFlow(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataFlow fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
