package com.xforceplus.jcmeiyijia.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单操作类型
 * </p>
 *
 * @author ultraman
 * @since 2021-09-16
 */
public enum SalesBillStatus {

    _0("0", "作废"),
    _1("1", "上传"),
    _9("9", "删除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesBillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesBillStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
