package com.xforceplus.jcmeiyijia.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-09-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Supplier implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("registerFrom")
  private String registerFrom;

  @TableField("companyName")
  private String companyName;

  @TableField("companyTaxNo")
  private String companyTaxNo;

  @TableField("userEmail")
  private String userEmail;

  @TableField("userPhone")
  private String userPhone;

  @TableField("userId")
  private String userId;

  @TableField("coopTenantCode")
  private String coopTenantCode;

  @TableField("sellerNo")
  private String sellerNo;

  @TableField("businessName")
  private String businessName;

  @TableField("businessEmail")
  private String businessEmail;

  @TableField("businessPhone")
  private String businessPhone;

  @TableField("businessTel")
  private String businessTel;

  @TableField("financeName")
  private String financeName;

  @TableField("financeEmail")
  private String financeEmail;

  @TableField("financePhone")
  private String financePhone;

  @TableField("financeTel")
  private String financeTel;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("hasCoopFlag")
  private String hasCoopFlag;

  private String result;

  private String status;

  @TableField("supplierTenantId")
  private Long supplierTenantId;

  @TableField("supplierTenantCode")
  private String supplierTenantCode;

  @TableField("supplierTenantName")
  private String supplierTenantName;

  @TableField("companyId")
  private Long companyId;

  @TableField("coopPush")
  private String coopPush;

  @TableField("coopReq")
  private String coopReq;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("registerFrom", registerFrom);
      map.put("companyName", companyName);
      map.put("companyTaxNo", companyTaxNo);
      map.put("userEmail", userEmail);
      map.put("userPhone", userPhone);
      map.put("userId", userId);
      map.put("coopTenantCode", coopTenantCode);
      map.put("sellerNo", sellerNo);
      map.put("businessName", businessName);
      map.put("businessEmail", businessEmail);
      map.put("businessPhone", businessPhone);
      map.put("businessTel", businessTel);
      map.put("financeName", financeName);
      map.put("financeEmail", financeEmail);
      map.put("financePhone", financePhone);
      map.put("financeTel", financeTel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("hasCoopFlag", hasCoopFlag);
      map.put("result", result);
      map.put("status", status);
      map.put("supplierTenantId", supplierTenantId);
      map.put("supplierTenantCode", supplierTenantCode);
      map.put("supplierTenantName", supplierTenantName);
      map.put("companyId", companyId);
      map.put("coopPush", coopPush);
      map.put("coopReq", coopReq);
      return map;
  }

  public static Supplier fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Supplier entity = new Supplier();
    if(map.containsKey("registerFrom")) {
      Object obj = map.get("registerFrom");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegisterFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userEmail")) {
      Object obj = map.get("userEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userPhone")) {
      Object obj = map.get("userPhone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userId")) {
      Object obj = map.get("userId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopTenantCode")) {
      Object obj = map.get("coopTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCoopTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessName")) {
      Object obj = map.get("businessName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessEmail")) {
      Object obj = map.get("businessEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessPhone")) {
      Object obj = map.get("businessPhone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTel")) {
      Object obj = map.get("businessTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeName")) {
      Object obj = map.get("financeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFinanceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeEmail")) {
      Object obj = map.get("financeEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFinanceEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financePhone")) {
      Object obj = map.get("financePhone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFinancePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeTel")) {
      Object obj = map.get("financeTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFinanceTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hasCoopFlag")) {
      Object obj = map.get("hasCoopFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHasCoopFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("result")) {
      Object obj = map.get("result");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantId")) {
      Object obj = map.get("supplierTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSupplierTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSupplierTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSupplierTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantCode")) {
      Object obj = map.get("supplierTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantName")) {
      Object obj = map.get("supplierTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("coopPush")) {
      Object obj = map.get("coopPush");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCoopPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopReq")) {
      Object obj = map.get("coopReq");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCoopReq((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
