package com.xforceplus.jcmeiyijia.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 商品审批管理
 * </p>
 *
 * @author ultraman
 * @since 2021-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsExamine implements Serializable {

  private static final long serialVersionUID=1L;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("applyStatus")
  private String applyStatus;

  @TableField("applyReason")
  private String applyReason;

  @TableField("applyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  @TableField("categoryCode")
  private String categoryCode;

  @TableField("goodsNo")
  private String goodsNo;

  @TableField("goodsId")
  private String goodsId;

  private String channel;

  @TableField("purchaseTaxNo")
  private String purchaseTaxNo;

  @TableField("purchaseTenantId")
  private Long purchaseTenantId;

  @TableField("sellerName")
  private String sellerName;

  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  @TableField("sellerTenantId")
  private Long sellerTenantId;

  @TableField("examineRemark")
  private String examineRemark;

  @TableField("examineUserId")
  private Long examineUserId;

  @TableField("examineTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime examineTime;

  @TableField("goodsModifyType1")
  private String goodsModifyType1;

  @TableField("oldValue1")
  private String oldValue1;

  @TableField("newValue1")
  private String newValue1;

  @TableField("goodsModifyType2")
  private String goodsModifyType2;

  @TableField("oldValue2")
  private String oldValue2;

  @TableField("newValue2")
  private String newValue2;

  @TableField("purchaseName")
  private String purchaseName;

  private String tid;

  @TableField("purchaseCompanyId")
  private String purchaseCompanyId;

  @TableField("sellerCompanyId")
  private String sellerCompanyId;

  @TableField("examineUserName")
  private String examineUserName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("applyStatus", applyStatus);
      map.put("applyReason", applyReason);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("categoryCode", categoryCode);
      map.put("goodsNo", goodsNo);
      map.put("goodsId", goodsId);
      map.put("channel", channel);
      map.put("purchaseTaxNo", purchaseTaxNo);
      map.put("purchaseTenantId", purchaseTenantId);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerTenantId", sellerTenantId);
      map.put("examineRemark", examineRemark);
      map.put("examineUserId", examineUserId);
      map.put("examineTime", BocpGenUtils.toTimestamp(examineTime));
      map.put("goodsModifyType1", goodsModifyType1);
      map.put("oldValue1", oldValue1);
      map.put("newValue1", newValue1);
      map.put("goodsModifyType2", goodsModifyType2);
      map.put("oldValue2", oldValue2);
      map.put("newValue2", newValue2);
      map.put("purchaseName", purchaseName);
      map.put("tid", tid);
      map.put("purchaseCompanyId", purchaseCompanyId);
      map.put("sellerCompanyId", sellerCompanyId);
      map.put("examineUserName", examineUserName);
      return map;
  }

  public static GoodsExamine fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsExamine entity = new GoodsExamine();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyStatus")) {
      Object obj = map.get("applyStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyReason")) {
      Object obj = map.get("applyReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsNo")) {
      Object obj = map.get("goodsNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsId")) {
      Object obj = map.get("goodsId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTaxNo")) {
      Object obj = map.get("purchaseTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTenantId")) {
      Object obj = map.get("purchaseTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaseTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaseTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("examineRemark")) {
      Object obj = map.get("examineRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExamineRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUserId")) {
      Object obj = map.get("examineUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExamineUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setExamineUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setExamineUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("examineTime")) {
      Object obj = map.get("examineTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setExamineTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExamineTime(null);
      }
    }
    if(map.containsKey("goodsModifyType1")) {
      Object obj = map.get("goodsModifyType1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsModifyType1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oldValue1")) {
      Object obj = map.get("oldValue1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOldValue1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newValue1")) {
      Object obj = map.get("newValue1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewValue1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsModifyType2")) {
      Object obj = map.get("goodsModifyType2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsModifyType2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oldValue2")) {
      Object obj = map.get("oldValue2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOldValue2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newValue2")) {
      Object obj = map.get("newValue2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewValue2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseName")) {
      Object obj = map.get("purchaseName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tid")) {
      Object obj = map.get("tid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyId")) {
      Object obj = map.get("purchaseCompanyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyId")) {
      Object obj = map.get("sellerCompanyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUserName")) {
      Object obj = map.get("examineUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExamineUserName((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
