package com.xforceplus.jcmeiyijia.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 商品明细修改日志管理
 * </p>
 *
 * @author ultraman
 * @since 2021-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsLog implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("goodsId")
  private Long goodsId;

  @TableField("goodsNo")
  private String goodsNo;

  @TableField("sellerCompanyName")
  private String sellerCompanyName;

  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  private String status;

  private String reason;

  @TableField("modifyType1")
  private String modifyType1;

  @TableField("oldValue1")
  private String oldValue1;

  @TableField("newValue1")
  private String newValue1;

  @TableField("modifyType2")
  private String modifyType2;

  @TableField("oldValue2")
  private String oldValue2;

  @TableField("newValue2")
  private String newValue2;

  private String tid;

  @TableField("submitTenantId")
  private String submitTenantId;

  @TableField("submitUserId")
  private String submitUserId;

  @TableField("submitCheckTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime submitCheckTime;

  @TableField("sellerNo")
  private String sellerNo;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("sellerCompanyId")
  private String sellerCompanyId;

  @TableField("sellerCompanyCode")
  private String sellerCompanyCode;

  @TableField("purchaseCompanyId")
  private String purchaseCompanyId;

  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  @TableField("modifyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime modifyTime;

  @TableField("submitUserName")
  private String submitUserName;

  @TableField("purchaseTaxNo")
  private String purchaseTaxNo;

  @TableField("sellerTaxNo")
  private String sellerTaxNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("goodsId", goodsId);
      map.put("goodsNo", goodsNo);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("status", status);
      map.put("reason", reason);
      map.put("modifyType1", modifyType1);
      map.put("oldValue1", oldValue1);
      map.put("newValue1", newValue1);
      map.put("modifyType2", modifyType2);
      map.put("oldValue2", oldValue2);
      map.put("newValue2", newValue2);
      map.put("tid", tid);
      map.put("submitTenantId", submitTenantId);
      map.put("submitUserId", submitUserId);
      map.put("submitCheckTime", BocpGenUtils.toTimestamp(submitCheckTime));
      map.put("sellerNo", sellerNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sellerCompanyId", sellerCompanyId);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("purchaseCompanyId", purchaseCompanyId);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("modifyTime", BocpGenUtils.toTimestamp(modifyTime));
      map.put("submitUserName", submitUserName);
      map.put("purchaseTaxNo", purchaseTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      return map;
  }

  public static GoodsLog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsLog entity = new GoodsLog();
    if(map.containsKey("goodsId")) {
      Object obj = map.get("goodsId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGoodsId((Long)obj);
        } else if(obj instanceof String) {
          entity.setGoodsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGoodsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("goodsNo")) {
      Object obj = map.get("goodsNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modifyType1")) {
      Object obj = map.get("modifyType1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setModifyType1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oldValue1")) {
      Object obj = map.get("oldValue1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOldValue1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newValue1")) {
      Object obj = map.get("newValue1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewValue1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modifyType2")) {
      Object obj = map.get("modifyType2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setModifyType2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oldValue2")) {
      Object obj = map.get("oldValue2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOldValue2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newValue2")) {
      Object obj = map.get("newValue2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewValue2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tid")) {
      Object obj = map.get("tid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitTenantId")) {
      Object obj = map.get("submitTenantId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitUserId")) {
      Object obj = map.get("submitUserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitCheckTime")) {
      Object obj = map.get("submitCheckTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSubmitCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSubmitCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSubmitCheckTime(null);
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyId")) {
      Object obj = map.get("sellerCompanyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyId")) {
      Object obj = map.get("purchaseCompanyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modifyTime")) {
      Object obj = map.get("modifyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setModifyTime(null);
      }
    }
    if(map.containsKey("submitUserName")) {
      Object obj = map.get("submitUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseTaxNo")) {
      Object obj = map.get("purchaseTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
