package com.xforceplus.jcmeiyijia.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 查验状态
 * </p>
 *
 * @author ultraman
 * @since 2021-08-02
 */
public enum VeriStatus {

    _0("0", "未查验"),
    _1("1", "待查验"),
    _2("2", "查验中"),
    _3("3", "查验成功"),
    _4("4", "查验失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VeriStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VeriStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
