package com.xforceplus.jcmeiyijia.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务状态变更类型
 * </p>
 *
 * @author ultraman
 * @since 2021-08-12
 */
public enum BusinessType {

    _2("2", "付款状态变更");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessType fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
