package com.xforceplus.jcmeiyijia.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 商品变更类型
 * </p>
 *
 * @author ultraman
 * @since 2021-08-12
 */
public enum GoodsModifyType {

    _0("0", "商品名称"),
    _1("1", "商品税编"),
    _("-", "-");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    GoodsModifyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsModifyType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "-":
                return _;
            default:
                return null;
        }
    }
}
