package com.xforceplus.jcmeiyijia.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证用途
 * </p>
 *
 * @author ultraman
 * @since 2021-09-06
 */
public enum AuthUse {

    _1("1", "抵扣勾选"),
    _2("2", "不抵扣勾选"),
    _10("10", "抵扣撤销勾选"),
    _20("20", "不抵扣撤销勾选");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthUse(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthUse fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "10":
                return _10;
            case "20":
                return _20;
            default:
                return null;
        }
    }
}
