package com.xforceplus.jcmeiyijia.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 接口业务类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-07
 */
public enum ApiBizType {

    _1("1", "业务单上传"),
    _2("2", "业务单上传反馈"),
    _3("3", "销项开票下发"),
    _4("4", "进项发票下发"),
    _5("5", "供应商入驻"),
    _6("6", "协同标识下发"),
    _7("7", "发票勾选"),
    _8("8", "勾选结果下发"),
    _9("9", "发票状态变更下发"),
    _10("10", "供应商发票锁定"),
    _11("11", "供应商发票解锁"),
    _12("12", "品类（大类）同步"),
    _13("13", "商品资料新增"),
    _14("14", "商品信息下发"),
    _15("15", "业务单作废"),
    _16("16", "进项发票付款状态变更"),
    _17("17", "商品审核状态变更"),
    _18("18", "品类与商品关系变更"),
    _19("19", "商品信息审核回写"),
    _20("20", "商品明细修改");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApiBizType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApiBizType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            default:
                return null;
        }
    }
}
