package com.xforceplus.jcmeiyijia.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票主信息
 * </p>
 *
 * @author ultraman
 * @since 2022-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMain implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 销方编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddrTel")
  private String sellerAddrTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 开票日期
   */
  @TableField("paperDrewDate")
  private Long paperDrewDate;

  /**
   * 备注
   */
  private String remark;

  /**
   * 收款人姓名
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人姓名
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 发票状态
   */
  private String status;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 红字信息表编号
   */
  @TableField("redNotificationNo")
  private String redNotificationNo;

  /**
   * 密文
   */
  @TableField("cipherText")
  private String cipherText;

  /**
   * 系统来源
   */
  @TableField("systemOrig")
  private String systemOrig;

  /**
   * 邮箱
   */
  @TableField("receiveUserEmail")
  private String receiveUserEmail;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankNameAccount")
  private String purchaserBankNameAccount;

  /**
   * 勾选状态
   */
  @TableField("authStatus")
  private String authStatus;

  /**
   * 红冲状态
   */
  @TableField("redStatus")
  private String redStatus;

  /**
   * 红冲时间
   */
  @TableField("redTime")
  private String redTime;

  /**
   * 红冲人姓名
   */
  @TableField("redUserName")
  private String redUserName;

  /**
   * 退票状态
   */
  @TableField("retreatStatus")
  private String retreatStatus;

  /**
   * 退票操作时间
   */
  @TableField("retreatTime")
  private String retreatTime;

  /**
   * 查验状态
   */
  @TableField("veriStatus")
  private String veriStatus;

  /**
   * 查验人
   */
  @TableField("veriUserName")
  private String veriUserName;

  /**
   * 冻结状态
   */
  @TableField("freezeStatus")
  private String freezeStatus;

  /**
   * 冻结操作时间
   */
  @TableField("freezeTime")
  private String freezeTime;

  /**
   * 冻结操作人姓名
   */
  @TableField("freezeUserName")
  private String freezeUserName;

  /**
   * 拓展字段1
   */
  private String ext1;

  /**
   * 拓展字段2
   */
  private String ext2;

  /**
   * 拓展字段3
   */
  private String ext3;

  /**
   * 发票来源 0-默认 11-销方直连 12-销方抽取 13-销方手工回填 21-国税验真 22-国税底账 31-影像识别
   */
  @TableField("invoiceOrig")
  private String invoiceOrig;

  /**
   * 销方公司
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 识别状态
   */
  @TableField("recogStatus")
  private String recogStatus;

  /**
   * 销方开具状态
   */
  @TableField("sellerSyncStatus")
  private String sellerSyncStatus;

  /**
   * PDF地址
   */
  @TableField("pdfUrl")
  private String pdfUrl;

  /**
   * 业务单号
   */
  @TableField("bussinessNo")
  private String bussinessNo;

  /**
   * 校验码
   */
  @TableField("checkCode")
  private String checkCode;

  /**
   * 购方编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 发票匹配状态
   */
  @TableField("matchStatus")
  private String matchStatus;

  /**
   * 发票匹配操作时间
   */
  @TableField("matchTime")
  private String matchTime;

  /**
   * 匹配金额
   */
  @TableField("matchAmount")
  private BigDecimal matchAmount;

  /**
   * 扫描抵扣联影像地址
   */
  @TableField("recogDeductionImageUrl")
  private String recogDeductionImageUrl;

  /**
   * 扫描发票联影像地址
   */
  @TableField("recogInvoiceImageUrl")
  private String recogInvoiceImageUrl;

  /**
   * 记账联
   */
  @TableField("recogChargeImageUrl")
  private String recogChargeImageUrl;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票ID
   */
  @TableField("invoiceId")
  private Long invoiceId;

  /**
   * 锁定状态
   */
  @TableField("lockStatus")
  private String lockStatus;

  /**
   * 底账勾选状态
   */
  @TableField("authSyncStatus")
  private String authSyncStatus;

  /**
   * 底帐获取时间，格式yyyy-MM-dd HH:mm:ss
   */
  @TableField("authSyncTime")
  private String authSyncTime;

  /**
   * 认证中台-发票勾选状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 认证中台-勾选发起时间
   */
  @TableField("checkingTime")
  private String checkingTime;

  /**
   * 认证中台-勾选失败原因
   */
  @TableField("checkFailureMessage")
  private String checkFailureMessage;

  /**
   * 勾选推送状态
   */
  @TableField("checkPush")
  private String checkPush;

  /**
   * 发票来源
   */
  @TableField("invoiceOrigin")
  private String invoiceOrigin;

  /**
   * 发票颜色
   */
  @TableField("invoiceColor")
  private String invoiceColor;

  /**
   * 红冲状态
   */
  @TableField("redFlag")
  private String redFlag;

  /**
   * 是否推送协同
   */
  @TableField("coopIsPush")
  private String coopIsPush;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceType", invoiceType);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("sellerNo", sellerNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("taxRate", taxRate);
      map.put("paperDrewDate", paperDrewDate);
      map.put("remark", remark);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("status", status);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redNotificationNo", redNotificationNo);
      map.put("cipherText", cipherText);
      map.put("systemOrig", systemOrig);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("purchaserBankNameAccount", purchaserBankNameAccount);
      map.put("authStatus", authStatus);
      map.put("redStatus", redStatus);
      map.put("redTime", redTime);
      map.put("redUserName", redUserName);
      map.put("retreatStatus", retreatStatus);
      map.put("retreatTime", retreatTime);
      map.put("veriStatus", veriStatus);
      map.put("veriUserName", veriUserName);
      map.put("freezeStatus", freezeStatus);
      map.put("freezeTime", freezeTime);
      map.put("freezeUserName", freezeUserName);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("invoiceOrig", invoiceOrig);
      map.put("sellerName", sellerName);
      map.put("recogStatus", recogStatus);
      map.put("sellerSyncStatus", sellerSyncStatus);
      map.put("pdfUrl", pdfUrl);
      map.put("bussinessNo", bussinessNo);
      map.put("checkCode", checkCode);
      map.put("purchaserNo", purchaserNo);
      map.put("matchStatus", matchStatus);
      map.put("matchTime", matchTime);
      map.put("matchAmount", matchAmount);
      map.put("recogDeductionImageUrl", recogDeductionImageUrl);
      map.put("recogInvoiceImageUrl", recogInvoiceImageUrl);
      map.put("recogChargeImageUrl", recogChargeImageUrl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceId", invoiceId);
      map.put("lockStatus", lockStatus);
      map.put("authSyncStatus", authSyncStatus);
      map.put("authSyncTime", authSyncTime);
      map.put("checkStatus", checkStatus);
      map.put("checkingTime", checkingTime);
      map.put("checkFailureMessage", checkFailureMessage);
      map.put("checkPush", checkPush);
      map.put("invoiceOrigin", invoiceOrigin);
      map.put("invoiceColor", invoiceColor);
      map.put("redFlag", redFlag);
      map.put("coopIsPush", coopIsPush);
      return map;
  }

  public static InvoiceMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMain entity = new InvoiceMain();
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrewDate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaperDrewDate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNameAccount")) {
      Object obj = map.get("purchaserBankNameAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriUserName")) {
      Object obj = map.get("veriUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeStatus")) {
      Object obj = map.get("freezeStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreezeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeTime")) {
      Object obj = map.get("freezeTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreezeTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeUserName")) {
      Object obj = map.get("freezeUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreezeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogStatus")) {
      Object obj = map.get("recogStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerSyncStatus")) {
      Object obj = map.get("sellerSyncStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussinessNo")) {
      Object obj = map.get("bussinessNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBussinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchTime")) {
      Object obj = map.get("matchTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchAmount")) {
      Object obj = map.get("matchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recogDeductionImageUrl")) {
      Object obj = map.get("recogDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogInvoiceImageUrl")) {
      Object obj = map.get("recogInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogChargeImageUrl")) {
      Object obj = map.get("recogChargeImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogChargeImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lockStatus")) {
      Object obj = map.get("lockStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSyncStatus")) {
      Object obj = map.get("authSyncStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSyncTime")) {
      Object obj = map.get("authSyncTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthSyncTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkingTime")) {
      Object obj = map.get("checkingTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkFailureMessage")) {
      Object obj = map.get("checkFailureMessage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckFailureMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkPush")) {
      Object obj = map.get("checkPush");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrigin")) {
      Object obj = map.get("invoiceOrigin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopIsPush")) {
      Object obj = map.get("coopIsPush");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCoopIsPush((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
