package com.xforceplus.jcmeiyijia.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 付款状态变更
 * </p>
 *
 * @author ultraman
 * @since 2022-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PaymentStatusChange implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 业务单号
   */
  @TableField("businessNo")
  private String businessNo;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 付款状态
   */
  @TableField("businessStatus")
  private String businessStatus;

  /**
   * 业务日期
   */
  @TableField("businessDate")
  private String businessDate;

  /**
   * 业务金额
   */
  @TableField("businessAmount")
  private String businessAmount;

  /**
   * 业务备注
   */
  @TableField("businessRemark")
  private String businessRemark;

  /**
   * 业务操作人
   */
  @TableField("businessOperateUserName")
  private String businessOperateUserName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 处理状态
   */
  private String status;

  /**
   * 处理结果
   */
  private String result;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("businessNo", businessNo);
      map.put("businessType", businessType);
      map.put("businessStatus", businessStatus);
      map.put("businessDate", businessDate);
      map.put("businessAmount", businessAmount);
      map.put("businessRemark", businessRemark);
      map.put("businessOperateUserName", businessOperateUserName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("status", status);
      map.put("result", result);
      return map;
  }

  public static PaymentStatusChange fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PaymentStatusChange entity = new PaymentStatusChange();
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessNo")) {
      Object obj = map.get("businessNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessStatus")) {
      Object obj = map.get("businessStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessDate")) {
      Object obj = map.get("businessDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessAmount")) {
      Object obj = map.get("businessAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessRemark")) {
      Object obj = map.get("businessRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessOperateUserName")) {
      Object obj = map.get("businessOperateUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessOperateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("result")) {
      Object obj = map.get("result");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResult((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
