package com.xforceplus.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.AttachImages;
import com.xforceplus.jcmeiyijia.service.IAttachImagesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-13
 */
@RestController
public class AttachImagesController {

  @Autowired
  private IAttachImagesService attachImagesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param attachImages ${table.comment}
   * @return
   */
  @GetMapping("/attachimagess" )
  public XfR getAttachImagess(XfPage page, AttachImages attachImages) {
    return XfR.ok(attachImagesServiceImpl.page(page, Wrappers.query(attachImages)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/attachimagess/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(attachImagesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param attachImages ${table.comment}
   * @return XfR
   */
  @PostMapping("/attachimagess")
  public XfR save(@RequestBody AttachImages attachImages) {
     return XfR.ok(attachImagesServiceImpl.save(attachImages));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param attachImages ${table.comment}
   * @return XfR
   */
  @PutMapping("/attachimagess/{id}")
  public XfR putUpdate(@RequestBody AttachImages attachImages,@PathVariable Long id) {
      attachImages.setId(id);
      return XfR.ok(attachImagesServiceImpl.updateById(attachImages));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param attachImages ${table.comment}
   * @return XfR
   */
  @PatchMapping("/attachimagess/{id}")
  public XfR patchUpdate(@RequestBody AttachImages attachImages,@PathVariable Long id) {
      AttachImages upattachImages = attachImagesServiceImpl.getById(id);
      if(upattachImages != null){
        upattachImages = ObjectCopyUtils.copyProperties(attachImages,upattachImages,true);
      }
      return XfR.ok(attachImagesServiceImpl.updateById(upattachImages));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/attachimagess/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(attachImagesServiceImpl.removeById(id));
  }

  @PostMapping("/attachimagess/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "attach_images");
     params.put("request", condition);

     return XfR.ok(attachImagesServiceImpl.querys(params));
  }

}
