package com.xforceplus.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.CategoryMain;
import com.xforceplus.jcmeiyijia.service.ICategoryMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-13
 */
@RestController
public class CategoryMainController {

  @Autowired
  private ICategoryMainService categoryMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param categoryMain ${table.comment}
   * @return
   */
  @GetMapping("/categorymains" )
  public XfR getCategoryMains(XfPage page, CategoryMain categoryMain) {
    return XfR.ok(categoryMainServiceImpl.page(page, Wrappers.query(categoryMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/categorymains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(categoryMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param categoryMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/categorymains")
  public XfR save(@RequestBody CategoryMain categoryMain) {
     return XfR.ok(categoryMainServiceImpl.save(categoryMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param categoryMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/categorymains/{id}")
  public XfR putUpdate(@RequestBody CategoryMain categoryMain,@PathVariable Long id) {
      categoryMain.setId(id);
      return XfR.ok(categoryMainServiceImpl.updateById(categoryMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param categoryMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/categorymains/{id}")
  public XfR patchUpdate(@RequestBody CategoryMain categoryMain,@PathVariable Long id) {
      CategoryMain upcategoryMain = categoryMainServiceImpl.getById(id);
      if(upcategoryMain != null){
        upcategoryMain = ObjectCopyUtils.copyProperties(categoryMain,upcategoryMain,true);
      }
      return XfR.ok(categoryMainServiceImpl.updateById(upcategoryMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/categorymains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(categoryMainServiceImpl.removeById(id));
  }

  @PostMapping("/categorymains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "category_main");
     params.put("request", condition);

     return XfR.ok(categoryMainServiceImpl.querys(params));
  }

}
