package com.xforceplus.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.GoodsLog;
import com.xforceplus.jcmeiyijia.service.IGoodsLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-19
 */
@RestController
public class GoodsLogController {

  @Autowired
  private IGoodsLogService goodsLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsLog ${table.comment}
   * @return
   */
  @GetMapping("/goodslogs" )
  public XfR getGoodsLogs(XfPage page, GoodsLog goodsLog) {
    return XfR.ok(goodsLogServiceImpl.page(page, Wrappers.query(goodsLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodslogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodslogs")
  public XfR save(@RequestBody GoodsLog goodsLog) {
     return XfR.ok(goodsLogServiceImpl.save(goodsLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodslogs/{id}")
  public XfR putUpdate(@RequestBody GoodsLog goodsLog,@PathVariable Long id) {
      goodsLog.setId(id);
      return XfR.ok(goodsLogServiceImpl.updateById(goodsLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodslogs/{id}")
  public XfR patchUpdate(@RequestBody GoodsLog goodsLog,@PathVariable Long id) {
      GoodsLog upgoodsLog = goodsLogServiceImpl.getById(id);
      if(upgoodsLog != null){
        upgoodsLog = ObjectCopyUtils.copyProperties(goodsLog,upgoodsLog,true);
      }
      return XfR.ok(goodsLogServiceImpl.updateById(upgoodsLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodslogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsLogServiceImpl.removeById(id));
  }

  @PostMapping("/goodslogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_log");
     params.put("request", condition);

     return XfR.ok(goodsLogServiceImpl.querys(params));
  }

}
