package com.xforceplus.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.GoodsMain;
import com.xforceplus.jcmeiyijia.service.IGoodsMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-06
 */
@RestController
public class GoodsMainController {

  @Autowired
  private IGoodsMainService goodsMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsMain ${table.comment}
   * @return
   */
  @GetMapping("/goodsmains" )
  public XfR getGoodsMains(XfPage page, GoodsMain goodsMain) {
    return XfR.ok(goodsMainServiceImpl.page(page, Wrappers.query(goodsMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodsmains")
  public XfR save(@RequestBody GoodsMain goodsMain) {
     return XfR.ok(goodsMainServiceImpl.save(goodsMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodsmains/{id}")
  public XfR putUpdate(@RequestBody GoodsMain goodsMain,@PathVariable Long id) {
      goodsMain.setId(id);
      return XfR.ok(goodsMainServiceImpl.updateById(goodsMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodsmains/{id}")
  public XfR patchUpdate(@RequestBody GoodsMain goodsMain,@PathVariable Long id) {
      GoodsMain upgoodsMain = goodsMainServiceImpl.getById(id);
      if(upgoodsMain != null){
        upgoodsMain = ObjectCopyUtils.copyProperties(goodsMain,upgoodsMain,true);
      }
      return XfR.ok(goodsMainServiceImpl.updateById(upgoodsMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsMainServiceImpl.removeById(id));
  }

  @PostMapping("/goodsmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_main");
     params.put("request", condition);

     return XfR.ok(goodsMainServiceImpl.querys(params));
  }

}
