package com.xforceplus.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmeiyijia.entity.PaymentStatusChange;
import com.xforceplus.jcmeiyijia.service.IPaymentStatusChangeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 付款状态变更前端控制器
 *
 * @author ultraman
 * @date 2022-11-17
 */
@RestController
public class PaymentStatusChangeController {

  @Autowired
  private IPaymentStatusChangeService paymentStatusChangeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paymentStatusChange 付款状态变更
   * @return
   */
  @GetMapping("/paymentstatuschanges" )
  public XfR getPaymentStatusChanges(XfPage page, PaymentStatusChange paymentStatusChange) {
    return XfR.ok(paymentStatusChangeServiceImpl.page(page, Wrappers.query(paymentStatusChange)));
  }

  /**
   * 通过id查询付款状态变更
   * @param  id
   * @return XfR
   */
  @GetMapping("/paymentstatuschanges/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentStatusChangeServiceImpl.getById(id));
  }

  /**
   * 新增付款状态变更
   * @param paymentStatusChange 付款状态变更
   * @return XfR
   */
  @PostMapping("/paymentstatuschanges")
  public XfR save(@RequestBody PaymentStatusChange paymentStatusChange) {
     return XfR.ok(paymentStatusChangeServiceImpl.save(paymentStatusChange));
  }

  /**
   * 修改-传入修改后的全部数据付款状态变更
   * @param paymentStatusChange 付款状态变更
   * @return XfR
   */
  @PutMapping("/paymentstatuschanges/{id}")
  public XfR putUpdate(@RequestBody PaymentStatusChange paymentStatusChange,@PathVariable Long id) {
      paymentStatusChange.setId(id);
      return XfR.ok(paymentStatusChangeServiceImpl.updateById(paymentStatusChange));
  }

  /**
   * 修改-传入修改的数据付款状态变更
   * @param paymentStatusChange 付款状态变更
   * @return XfR
   */
  @PatchMapping("/paymentstatuschanges/{id}")
  public XfR patchUpdate(@RequestBody PaymentStatusChange paymentStatusChange,@PathVariable Long id) {
      PaymentStatusChange uppaymentStatusChange = paymentStatusChangeServiceImpl.getById(id);
      if(uppaymentStatusChange != null){
        uppaymentStatusChange = ObjectCopyUtils.copyProperties(paymentStatusChange,uppaymentStatusChange,true);
      }
      return XfR.ok(paymentStatusChangeServiceImpl.updateById(uppaymentStatusChange));
  }

  /**
   * 通过id删除付款状态变更
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paymentstatuschanges/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentStatusChangeServiceImpl.removeById(id));
  }

  @PostMapping("/paymentstatuschanges/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment_status_change");
     params.put("request", condition);

     return XfR.ok(paymentStatusChangeServiceImpl.querys(params));
  }

}
