package com.xforceplus.jcmetro.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-06-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcmetro.entity.BizOrderMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-metro")
public interface BizOrderMainFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/bizOrderMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param bizOrderMain ${table.comment}
   * @return R
   */
  @PostMapping("/bizOrderMain/add")
  public R save(@RequestBody BizOrderMain bizOrderMain);

  /**
   * 修改${table.comment}
   * @param bizOrderMain ${table.comment}
   * @return R
   */
  @PostMapping("/bizOrderMain/update")
  public R updateById(@RequestBody BizOrderMain bizOrderMain);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizOrderMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}