package com.xforceplus.jcmetro.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-05-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcmetro.entity.BizOrderRedLetter;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-metro")
public interface BizOrderRedLetterFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/bizOrderRedLetter/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param bizOrderRedLetter ${table.comment}
   * @return R
   */
  @PostMapping("/bizOrderRedLetter/add")
  public R save(@RequestBody BizOrderRedLetter bizOrderRedLetter);

  /**
   * 修改${table.comment}
   * @param bizOrderRedLetter ${table.comment}
   * @return R
   */
  @PostMapping("/bizOrderRedLetter/update")
  public R updateById(@RequestBody BizOrderRedLetter bizOrderRedLetter);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizOrderRedLetter/del/{id}" )
  public R removeById(@PathVariable Long id);

}