package com.xforceplus.jcmksp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据状态
 * </p>
 *
 * @author ultraman
 * @since 2022-09-05
 */
public enum BillStatus {

    _0("0", "待上传"),
    __1("-1", "上传失败"),
    _1("1", "上传成功"),
    _9("9", "已作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "-1":
                return __1;
            case "1":
                return _1;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
