package com.xforceplus.jcmksp.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GtsReport implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 币种
   */
  private String currency;

  /**
   * 币种类型
   */
  private String currencyType;

  /**
   * Record Type
   */
  private String recordType;

  /**
   * Period/Year
   */
  private String periodYear;

  /**
   * Document number
   */
  private String documentNumber;

  /**
   * Billing单号
   */
  private String referenceDocument;

  /**
   * Billing行号
   */
  private String referenceItemNo;

  /**
   * 利润中心(销售公司编号)
   */
  private String salesOrganization;

  /**
   * Distribution Channel
   */
  private String distributionChannel;

  /**
   * Cost Element
   */
  private String costElement;

  /**
   * Profit Center
   */
  private String profitCenter;

  /**
   * Industry Segment PF
   */
  private String industrySegmentPf;

  /**
   * 商品编号
   */
  private String product;

  /**
   * 购方编号
   */
  private String customer;

  /**
   * 付款客户
   */
  private String billToParty;

  /**
   * 发货客户配送地址
   */
  private String shipToParty;

  /**
   * 数量
   */
  private BigDecimal quantityInBuon;

  /**
   * Quantity in KG
   */
  private BigDecimal quantityInKg;

  /**
   * Cost of Sales
   */
  private BigDecimal costOfSales;

  /**
   * Cost of Sales Other
   */
  private BigDecimal costOfSalesOther;

  /**
   * Deferred - Ind. Frei
   */
  private BigDecimal deferredIndFrei;

  /**
   * Fuel Surc. Direct
   */
  private BigDecimal fuelSurcDirect;

  /**
   * Fuel Surc. Indirect
   */
  private BigDecimal fuelSurcIndirect;

  /**
   * Standard - Direct Fr
   */
  private BigDecimal standardDirectFr;

  /**
   * Storage
   */
  private BigDecimal storage;

  /**
   * 未税金额
   */
  private BigDecimal sales;

  /**
   * 搭赠和免费品折扣(未税)
   */
  private BigDecimal oiTempPriceRed;

  /**
   * 预提折扣(未税)
   */
  private BigDecimal acTempPzReduction;

  /**
   * 大车小车折扣(未税)
   */
  private BigDecimal oiTruckioadDiscoun;

  /**
   * JBP折扣(折扣)
   */
  private BigDecimal acGrowthProgDir;

  /**
   * 过账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;

  /**
   * 订单号
   */
  private String salesOrder;

  /**
   * Created On
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createdOn;

  /**
   * billno加itemno
   */
  @TableField("billNo_itemNo")
  private String billnoItemno;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据状态
   */
  private String billStatus;

  /**
   * 开票状态
   */
  private String kpStatus;

  /**
   * 匹配状态
   */
  private String matchStatus;

  /**
   * 明细匹配状态
   */
  private String detailMatchStatus;

  /**
   * 业务单明细号
   */
  @TableField("billNo_reference_item_no")
  private String billnoReferenceItemNo;

  /**
   * po单号
   */
  private String poOrder;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("currency", currency);
      map.put("currency_type", currencyType);
      map.put("record_type", recordType);
      map.put("period_year", periodYear);
      map.put("document_number", documentNumber);
      map.put("reference_document", referenceDocument);
      map.put("reference_item_no", referenceItemNo);
      map.put("sales_organization", salesOrganization);
      map.put("distribution_channel", distributionChannel);
      map.put("cost_element", costElement);
      map.put("profit_center", profitCenter);
      map.put("industry_segment_pf", industrySegmentPf);
      map.put("product", product);
      map.put("customer", customer);
      map.put("bill_to_party", billToParty);
      map.put("ship_to_party", shipToParty);
      map.put("quantity_in_buon", quantityInBuon);
      map.put("quantity_in_kg", quantityInKg);
      map.put("cost_of_sales", costOfSales);
      map.put("cost_of_sales_other", costOfSalesOther);
      map.put("deferred_ind_frei", deferredIndFrei);
      map.put("fuel_surc_direct", fuelSurcDirect);
      map.put("fuel_surc_indirect", fuelSurcIndirect);
      map.put("standard_direct_fr", standardDirectFr);
      map.put("storage", storage);
      map.put("sales", sales);
      map.put("oi_temp_price_red", oiTempPriceRed);
      map.put("ac_temp_pz_reduction", acTempPzReduction);
      map.put("oi_truckioad_discoun", oiTruckioadDiscoun);
      map.put("ac_growth_prog_dir", acGrowthProgDir);
      map.put("posting_date", BocpGenUtils.toTimestamp(postingDate));
      map.put("sales_order", salesOrder);
      map.put("created_on", BocpGenUtils.toTimestamp(createdOn));
      map.put("billNo_itemNo", billnoItemno);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bill_status", billStatus);
      map.put("kp_status", kpStatus);
      map.put("match_status", matchStatus);
      map.put("detail_match_status", detailMatchStatus);
      map.put("billNo_reference_item_no", billnoReferenceItemNo);
      map.put("po_order", poOrder);
      return map;
  }

  public static GtsReport fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GtsReport entity = new GtsReport();
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency_type")) {
      Object obj = map.get("currency_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrencyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("record_type")) {
      Object obj = map.get("record_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecordType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("period_year")) {
      Object obj = map.get("period_year");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeriodYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_number")) {
      Object obj = map.get("document_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference_document")) {
      Object obj = map.get("reference_document");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReferenceDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference_item_no")) {
      Object obj = map.get("reference_item_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReferenceItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_organization")) {
      Object obj = map.get("sales_organization");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesOrganization((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distribution_channel")) {
      Object obj = map.get("distribution_channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDistributionChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_element")) {
      Object obj = map.get("cost_element");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostElement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("profit_center")) {
      Object obj = map.get("profit_center");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("industry_segment_pf")) {
      Object obj = map.get("industry_segment_pf");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIndustrySegmentPf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProduct((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_to_party")) {
      Object obj = map.get("bill_to_party");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillToParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ship_to_party")) {
      Object obj = map.get("ship_to_party");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShipToParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity_in_buon")) {
      Object obj = map.get("quantity_in_buon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantityInBuon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantityInBuon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantityInBuon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantityInBuon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantityInBuon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity_in_kg")) {
      Object obj = map.get("quantity_in_kg");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantityInKg((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantityInKg(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantityInKg(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantityInKg(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantityInKg(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cost_of_sales")) {
      Object obj = map.get("cost_of_sales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCostOfSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCostOfSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCostOfSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCostOfSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCostOfSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cost_of_sales_other")) {
      Object obj = map.get("cost_of_sales_other");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCostOfSalesOther((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCostOfSalesOther(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCostOfSalesOther(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCostOfSalesOther(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCostOfSalesOther(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deferred_ind_frei")) {
      Object obj = map.get("deferred_ind_frei");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeferredIndFrei((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeferredIndFrei(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeferredIndFrei(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeferredIndFrei(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeferredIndFrei(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fuel_surc_direct")) {
      Object obj = map.get("fuel_surc_direct");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFuelSurcDirect((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFuelSurcDirect(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFuelSurcDirect(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFuelSurcDirect(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFuelSurcDirect(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fuel_surc_indirect")) {
      Object obj = map.get("fuel_surc_indirect");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFuelSurcIndirect((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFuelSurcIndirect(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFuelSurcIndirect(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFuelSurcIndirect(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFuelSurcIndirect(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("standard_direct_fr")) {
      Object obj = map.get("standard_direct_fr");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStandardDirectFr((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStandardDirectFr(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStandardDirectFr(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setStandardDirectFr(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStandardDirectFr(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("storage")) {
      Object obj = map.get("storage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStorage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStorage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStorage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setStorage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStorage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales")) {
      Object obj = map.get("sales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("oi_temp_price_red")) {
      Object obj = map.get("oi_temp_price_red");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOiTempPriceRed((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOiTempPriceRed(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOiTempPriceRed(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOiTempPriceRed(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOiTempPriceRed(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ac_temp_pz_reduction")) {
      Object obj = map.get("ac_temp_pz_reduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAcTempPzReduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAcTempPzReduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAcTempPzReduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAcTempPzReduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAcTempPzReduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("oi_truckioad_discoun")) {
      Object obj = map.get("oi_truckioad_discoun");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOiTruckioadDiscoun((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOiTruckioadDiscoun(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOiTruckioadDiscoun(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOiTruckioadDiscoun(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOiTruckioadDiscoun(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ac_growth_prog_dir")) {
      Object obj = map.get("ac_growth_prog_dir");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAcGrowthProgDir((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAcGrowthProgDir(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAcGrowthProgDir(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAcGrowthProgDir(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAcGrowthProgDir(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("posting_date")) {
      Object obj = map.get("posting_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("sales_order")) {
      Object obj = map.get("sales_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("created_on")) {
      Object obj = map.get("created_on");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreatedOn(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreatedOn((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreatedOn(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreatedOn(null);
      }
    }
    if(map.containsKey("billNo_itemNo")) {
      Object obj = map.get("billNo_itemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillnoItemno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_status")) {
      Object obj = map.get("bill_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kp_status")) {
      Object obj = map.get("kp_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detail_match_status")) {
      Object obj = map.get("detail_match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetailMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo_reference_item_no")) {
      Object obj = map.get("billNo_reference_item_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillnoReferenceItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("po_order")) {
      Object obj = map.get("po_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoOrder((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
