package com.xforceplus.jcmksp.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceRelation implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  private String salesBillNo;

  /**
   * 业务单明细id
   */
  private Long salesBillItemId;

  /**
   * 业务单明细号
   */
  private String salesBillItemNo;

  /**
   * 预制发票id
   */
  private Long preInvoiceItemId;

  /**
   * 发票明细id
   */
  private Long invoiceItemId;

  /**
   * 明细税额
   */
  private BigDecimal taxAmount;

  /**
   * 明细含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 明细不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 拓展字段1
   */
  private String ext1;

  /**
   * 拓展字段2
   */
  private String ext2;

  /**
   * 拓展字段3
   */
  private String ext3;

  /**
   * 拓展字段4
   */
  private String ext4;

  /**
   * 拓展字段5
   */
  private String ext5;

  /**
   * 取消标识
   */
  private String cancelFlag;

  /**
   * 发票种类
   */
  private String invoiceType;

  /**
   * billing单号
   */
  private String billingNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 客户编号
   */
  private String customerNo;

  /**
   * 客户名称
   */
  private String customerName;

  /**
   * 客户税号
   */
  private String customerTaxNo;

  /**
   * 客户地址电话
   */
  private String customerAddressTel;

  /**
   * 客户银行账号
   */
  private String customerBankAccount;

  /**
   * 备注信息
   */
  private String remark;

  /**
   * 收款人姓名
   */
  private String cashierName;

  /**
   * 开票人
   */
  private String invoicerName;

  /**
   * 复核人姓名
   */
  private String checkerName;

  /**
   * 销方银行账号
   */
  private String sellerBankAccount;

  /**
   * 销方地址电话
   */
  private String sellerAddressTel;

  /**
   * 商品编号
   */
  private String itemCode;

  /**
   * 商品名称
   */
  private String itemName;

  /**
   * 规格型号
   */
  private String itemModel;

  /**
   * 计量单位
   */
  private String quantityUnit;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 金额
   */
  private BigDecimal sapAmount;

  /**
   * 税率
   */
  private BigDecimal sapTaxRate;

  /**
   * 税额
   */
  private BigDecimal sapTaxAmount;

  /**
   * 收货人
   */
  private String consignee;

  /**
   * 收货人纳税人识别号
   */
  private String consigneeTaxNo;

  /**
   * 发货人
   */
  private String consigner;

  /**
   * 发货人纳税人识别号
   */
  private String consignerTaxNo;

  /**
   * 起运地、经由、到达地
   */
  private String place;

  /**
   * 车种车号
   */
  private String carModel;

  /**
   * 车船吨位
   */
  private String tonnage;

  /**
   * 运输货物信息
   */
  private String transferCargoInfo;

  /**
   * 编码版本号
   */
  private String codeVersion;

  /**
   * 税收分类编码
   */
  private String goodsTaxNo;

  /**
   * 是否享受优惠政策
   */
  private String taxPre;

  /**
   * 享受税收优惠政策内容
   */
  private String taxPreCon;

  /**
   * 零税率标识
   */
  private String zeroTax;

  /**
   * 扣除额
   */
  private BigDecimal deduction;

  /**
   * 开票日期
   */
  private String paperDrewDate;

  /**
   * 不含税折扣金额
   */
  private BigDecimal outDiscountWithoutTax;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("sales_bill_no", salesBillNo);
      map.put("sales_bill_item_id", salesBillItemId);
      map.put("sales_bill_item_no", salesBillItemNo);
      map.put("pre_invoice_item_id", preInvoiceItemId);
      map.put("invoice_item_id", invoiceItemId);
      map.put("tax_amount", taxAmount);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("cancel_flag", cancelFlag);
      map.put("invoice_type", invoiceType);
      map.put("billing_no", billingNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("customer_no", customerNo);
      map.put("customer_name", customerName);
      map.put("customer_tax_no", customerTaxNo);
      map.put("customer_address_tel", customerAddressTel);
      map.put("customer_bank_account", customerBankAccount);
      map.put("remark", remark);
      map.put("cashier_name", cashierName);
      map.put("invoicer_name", invoicerName);
      map.put("checker_name", checkerName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("seller_address_tel", sellerAddressTel);
      map.put("item_code", itemCode);
      map.put("item_name", itemName);
      map.put("item_model", itemModel);
      map.put("quantity_unit", quantityUnit);
      map.put("quantity", quantity);
      map.put("sap_amount", sapAmount);
      map.put("sap_tax_rate", sapTaxRate);
      map.put("sap_tax_amount", sapTaxAmount);
      map.put("consignee", consignee);
      map.put("consignee_tax_no", consigneeTaxNo);
      map.put("consigner", consigner);
      map.put("consigner_tax_no", consignerTaxNo);
      map.put("place", place);
      map.put("car_model", carModel);
      map.put("tonnage", tonnage);
      map.put("transfer_cargo_info", transferCargoInfo);
      map.put("code_version", codeVersion);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("tax_pre", taxPre);
      map.put("tax_pre_con", taxPreCon);
      map.put("zero_tax", zeroTax);
      map.put("deduction", deduction);
      map.put("paper_drew_date", paperDrewDate);
      map.put("out_discount_without_tax", outDiscountWithoutTax);
      return map;
  }

  public static InvoiceRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceRelation entity = new InvoiceRelation();
    if(map.containsKey("sales_bill_no")) {
      Object obj = map.get("sales_bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_bill_item_id")) {
      Object obj = map.get("sales_bill_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesBillItemId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSalesBillItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSalesBillItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sales_bill_item_no")) {
      Object obj = map.get("sales_bill_item_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pre_invoice_item_id")) {
      Object obj = map.get("pre_invoice_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPreInvoiceItemId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPreInvoiceItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPreInvoiceItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_item_id")) {
      Object obj = map.get("invoice_item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceItemId((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancel_flag")) {
      Object obj = map.get("cancel_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCancelFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billing_no")) {
      Object obj = map.get("billing_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_tax_no")) {
      Object obj = map.get("customer_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_address_tel")) {
      Object obj = map.get("customer_address_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_bank_account")) {
      Object obj = map.get("customer_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address_tel")) {
      Object obj = map.get("seller_address_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_model")) {
      Object obj = map.get("item_model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sap_amount")) {
      Object obj = map.get("sap_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSapAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSapAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSapAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSapAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSapAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sap_tax_rate")) {
      Object obj = map.get("sap_tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSapTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSapTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSapTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSapTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSapTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sap_tax_amount")) {
      Object obj = map.get("sap_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSapTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSapTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSapTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSapTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSapTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("consignee")) {
      Object obj = map.get("consignee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConsignee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignee_tax_no")) {
      Object obj = map.get("consignee_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConsigneeTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consigner")) {
      Object obj = map.get("consigner");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConsigner((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consigner_tax_no")) {
      Object obj = map.get("consigner_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConsignerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("place")) {
      Object obj = map.get("place");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("car_model")) {
      Object obj = map.get("car_model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCarModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transfer_cargo_info")) {
      Object obj = map.get("transfer_cargo_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTransferCargoInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("code_version")) {
      Object obj = map.get("code_version");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCodeVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre")) {
      Object obj = map.get("tax_pre");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_con")) {
      Object obj = map.get("tax_pre_con");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zero_tax")) {
      Object obj = map.get("zero_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("out_discount_without_tax")) {
      Object obj = map.get("out_discount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
