package com.xforceplus.jcmksp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmksp.entity.GtsFile;
import com.xforceplus.jcmksp.service.IGtsFileService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-05
 */
@RestController
public class GtsFileController {

  @Autowired
  private IGtsFileService gtsFileServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param gtsFile ${table.comment}
   * @return
   */
  @GetMapping("/gtsfiles" )
  public XfR getGtsFiles(XfPage page, GtsFile gtsFile) {
    return XfR.ok(gtsFileServiceImpl.page(page, Wrappers.query(gtsFile)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/gtsfiles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(gtsFileServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param gtsFile ${table.comment}
   * @return XfR
   */
  @PostMapping("/gtsfiles")
  public XfR save(@RequestBody GtsFile gtsFile) {
     return XfR.ok(gtsFileServiceImpl.save(gtsFile));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param gtsFile ${table.comment}
   * @return XfR
   */
  @PutMapping("/gtsfiles/{id}")
  public XfR putUpdate(@RequestBody GtsFile gtsFile,@PathVariable Long id) {
      gtsFile.setId(id);
      return XfR.ok(gtsFileServiceImpl.updateById(gtsFile));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param gtsFile ${table.comment}
   * @return XfR
   */
  @PatchMapping("/gtsfiles/{id}")
  public XfR patchUpdate(@RequestBody GtsFile gtsFile,@PathVariable Long id) {
      GtsFile upgtsFile = gtsFileServiceImpl.getById(id);
      if(upgtsFile != null){
        upgtsFile = ObjectCopyUtils.copyProperties(gtsFile,upgtsFile,true);
      }
      return XfR.ok(gtsFileServiceImpl.updateById(upgtsFile));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/gtsfiles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(gtsFileServiceImpl.removeById(id));
  }

  @PostMapping("/gtsfiles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "gts_file");
     params.put("request", condition);

     return XfR.ok(gtsFileServiceImpl.querys(params));
  }

}
