package com.xforceplus.jcmksp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmksp.entity.GtsReport;
import com.xforceplus.jcmksp.service.IGtsReportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-05
 */
@RestController
public class GtsReportController {

  @Autowired
  private IGtsReportService gtsReportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param gtsReport ${table.comment}
   * @return
   */
  @GetMapping("/gtsreports" )
  public XfR getGtsReports(XfPage page, GtsReport gtsReport) {
    return XfR.ok(gtsReportServiceImpl.page(page, Wrappers.query(gtsReport)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/gtsreports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(gtsReportServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param gtsReport ${table.comment}
   * @return XfR
   */
  @PostMapping("/gtsreports")
  public XfR save(@RequestBody GtsReport gtsReport) {
     return XfR.ok(gtsReportServiceImpl.save(gtsReport));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param gtsReport ${table.comment}
   * @return XfR
   */
  @PutMapping("/gtsreports/{id}")
  public XfR putUpdate(@RequestBody GtsReport gtsReport,@PathVariable Long id) {
      gtsReport.setId(id);
      return XfR.ok(gtsReportServiceImpl.updateById(gtsReport));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param gtsReport ${table.comment}
   * @return XfR
   */
  @PatchMapping("/gtsreports/{id}")
  public XfR patchUpdate(@RequestBody GtsReport gtsReport,@PathVariable Long id) {
      GtsReport upgtsReport = gtsReportServiceImpl.getById(id);
      if(upgtsReport != null){
        upgtsReport = ObjectCopyUtils.copyProperties(gtsReport,upgtsReport,true);
      }
      return XfR.ok(gtsReportServiceImpl.updateById(upgtsReport));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/gtsreports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(gtsReportServiceImpl.removeById(id));
  }

  @PostMapping("/gtsreports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "gts_report");
     params.put("request", condition);

     return XfR.ok(gtsReportServiceImpl.querys(params));
  }

}
