package com.xforceplus.jcmksp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmksp.entity.BillingDetails;
import com.xforceplus.jcmksp.service.IBillingDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-19
 */
@RestController
public class BillingDetailsController {

  @Autowired
  private IBillingDetailsService billingDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingDetails ${table.comment}
   * @return
   */
  @GetMapping("/billingdetailss" )
  public XfR getBillingDetailss(XfPage page, BillingDetails billingDetails) {
    return XfR.ok(billingDetailsServiceImpl.page(page, Wrappers.query(billingDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingdetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/billingdetailss")
  public XfR save(@RequestBody BillingDetails billingDetails) {
     return XfR.ok(billingDetailsServiceImpl.save(billingDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/billingdetailss/{id}")
  public XfR putUpdate(@RequestBody BillingDetails billingDetails,@PathVariable Long id) {
      billingDetails.setId(id);
      return XfR.ok(billingDetailsServiceImpl.updateById(billingDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billingdetailss/{id}")
  public XfR patchUpdate(@RequestBody BillingDetails billingDetails,@PathVariable Long id) {
      BillingDetails upbillingDetails = billingDetailsServiceImpl.getById(id);
      if(upbillingDetails != null){
        upbillingDetails = ObjectCopyUtils.copyProperties(billingDetails,upbillingDetails,true);
      }
      return XfR.ok(billingDetailsServiceImpl.updateById(upbillingDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingdetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/billingdetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_details");
     params.put("request", condition);

     return XfR.ok(billingDetailsServiceImpl.querys(params));
  }

}
