package com.xforceplus.jcmksp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcmksp.entity.BillingMain;
import com.xforceplus.jcmksp.service.IBillingMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-19
 */
@RestController
public class BillingMainController {

  @Autowired
  private IBillingMainService billingMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billingMain ${table.comment}
   * @return
   */
  @GetMapping("/billingmains" )
  public XfR getBillingMains(XfPage page, BillingMain billingMain) {
    return XfR.ok(billingMainServiceImpl.page(page, Wrappers.query(billingMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billingmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billingMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/billingmains")
  public XfR save(@RequestBody BillingMain billingMain) {
     return XfR.ok(billingMainServiceImpl.save(billingMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billingMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/billingmains/{id}")
  public XfR putUpdate(@RequestBody BillingMain billingMain,@PathVariable Long id) {
      billingMain.setId(id);
      return XfR.ok(billingMainServiceImpl.updateById(billingMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billingMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billingmains/{id}")
  public XfR patchUpdate(@RequestBody BillingMain billingMain,@PathVariable Long id) {
      BillingMain upbillingMain = billingMainServiceImpl.getById(id);
      if(upbillingMain != null){
        upbillingMain = ObjectCopyUtils.copyProperties(billingMain,upbillingMain,true);
      }
      return XfR.ok(billingMainServiceImpl.updateById(upbillingMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billingmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingMainServiceImpl.removeById(id));
  }

  @PostMapping("/billingmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing_main");
     params.put("request", condition);

     return XfR.ok(billingMainServiceImpl.querys(params));
  }

}
