package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_reason
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ApplyReason {

    MAKING_ERROR("making_error", "开票有误"),
    TAXABLE_SERVICE_END("taxable_service_end", "应税服务中止"),
    SALES_ALLOWANCE("sales_allowance", "销售折让"),
    SALES_RETURN("sales_return", "销售退回");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyReason fromCode(String code){
        switch(code) {
            case "making_error":
                return MAKING_ERROR;
            case "taxable_service_end":
                return TAXABLE_SERVICE_END;
            case "sales_allowance":
                return SALES_ALLOWANCE;
            case "sales_return":
                return SALES_RETURN;
            default:
                return null;
        }
    }
}
