package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * attachment_generation_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum AttachmentGenerationStatus {

    _0("0", "待生成"),
    _1("1", "部分生成"),
    _2("2", "全部生成"),
    __1("-1", "生成失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AttachmentGenerationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AttachmentGenerationStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
