package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * attachment_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum AttachmentType {

    DEPOSIT_RECEIPT("depositReceipt", "押金收据"),
    RETURN_AGREEMENT("returnAgreement", "退货协议"),
    DISCOUNT_AGREEMENT("discountAgreement", "折让协议"),
    RETURN_AGREEMENT_CONFIRMATION("returnAgreementConfirmation", "退货协议确认书");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AttachmentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AttachmentType fromCode(String code){
        switch(code) {
            case "depositReceipt":
                return DEPOSIT_RECEIPT;
            case "returnAgreement":
                return RETURN_AGREEMENT;
            case "discountAgreement":
                return DISCOUNT_AGREEMENT;
            case "returnAgreementConfirmation":
                return RETURN_AGREEMENT_CONFIRMATION;
            default:
                return null;
        }
    }
}
