package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * email_template
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum EmailTemplate {

    MT445243507437("MT445243507437", "退货邮件模版"),
    MT445243733818("MT445243733818", "折让邮件模版"),
    MT445243946323("MT445243946323", "收据发送邮件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EmailTemplate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EmailTemplate fromCode(String code){
        switch(code) {
            case "MT445243507437":
                return MT445243507437;
            case "MT445243733818":
                return MT445243733818;
            case "MT445243946323":
                return MT445243946323;
            default:
                return null;
        }
    }
}
