package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * item_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ItemStatus {

    _0("0", "已作废"),
    _1("1", "正常，未开具"),
    _2("2", "开票已提交"),
    _3("3", "已开票"),
    _4("4", "已退回"),
    _9("9", "已删除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ItemStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
