package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * receipt_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ReceiptStatus {

    _0("0", "未生成"),
    _1("1", "生成待盖章"),
    _2("2", "生成已盖章"),
    _3("3", "已发邮件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReceiptStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiptStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
