package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seal_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum SealType {

    COMPANY_SEAL("companySeal", "公章"),
    FINANCE_SEAL("financeSeal", "财务章");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SealType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SealType fromCode(String code){
        switch(code) {
            case "companySeal":
                return COMPANY_SEAL;
            case "financeSeal":
                return FINANCE_SEAL;
            default:
                return null;
        }
    }
}
