package com.xforceplus.jcnestle.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * stamped_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum StampedStatus {

    PENDING("pending", "待盖章"),
    IN_PROGRESS("inProgress", "盖章中"),
    COMPLETED("completed", "已盖章");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StampedStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StampedStatus fromCode(String code){
        switch(code) {
            case "pending":
                return PENDING;
            case "inProgress":
                return IN_PROGRESS;
            case "completed":
                return COMPLETED;
            default:
                return null;
        }
    }
}
